#!/usr/bin/perl
#
# man Getopt::Std, Getopt::Long, Switch,File::Basename
# System commands: chdir,mkdir,rmdir,readdir,rename,unlink,copy,move,stat
# Var: $ENV{HOME},@ARGV(no progname),$ARGV(name of curr file while reading<>
#      <ARGV>(read filenames in com.line),$PID (or $$),$OFS(out.field sep),
#      @files = @ARGV[ 2 .. $#ARGV ] list of files from 3rd to last arg.
#      $ORS(out.rec.sep),$RS(rec.sep),$NR(record number) 
# Com: grep
# Control:foreach,for,last(break),next
#         foreach $file (<*.c>){}
#BEGIN{  #for use in awk mode
#awk line:@F = split (' '); $NF = $#F; #  $F[0], $F[1], ... , $F[$NF]
#pipes:open(W,"|jack");print W $mydata;open(R,"sort|");while(<R>){...}
#pipes:use IPC::Open2;open2(*R,*W,"grep ^2");while(<>){print W;};close(W);print <R>;
# Here documents: commands
#  print << `EOC`;
#  gnuplot -persist << EOF;
# plot "<time-series $o $files" u 1 w l notit
# EOF
# EOC

use Getopt::Std;
use Switch 'Perl6'; use Sys::Hostname;
use File::Basename; use File::Copy; use File::Find; use Cwd;
# --------------------- OPTIONS       --------------------------------
$cdir = cwd;chomp($cdir);$home=$ENV{$HOME};$host = hostname;
$prog = basename($0);
getopt('Tt', \%opts); #here we add only options with args
foreach $opt (keys %opts){
 given($opt){
  when /[tT]/ {$t = $opts{$opt};print "${opt}: handling T\n";last;}
  when 'h' {usage();last;}
  default  {usage("Not a valid option: $opt");}
 }
}
#} #end BEGIN{}
# -------------------------------------------------------------------
# ----------------------- HELP MESSAGE ------------------------------
sub usage(){
 if(@_){$message  = shift(@_)."\n";}
 $message .= << "EOF";
Usage: ${prog} [options]
EOF
 print STDERR $message;
 exit(1);
}
sub main::HELP_MESSAGE(){ usage();} #for --help (does not work when default?)
# -------------------------------------------------------------------
if($#ARGV < -1){usage();} #$ARGV[0-] arguments (not progname) $#ARGV=-1 (noarg)


