C     Program to compute roots of 2nd order polynomial
C     Tasks: Input from user, logical statements, use of functions,stop
C            Accuracy in floating point arithmetic (e.g. IF(x.eq.0.0)....)
C  
C     Tests: a,b,c= 1  2  3 D=   -8
C            a,b,c= 1 -8 16 D=    0  x1=   4
C            a,b,c= 1 -1 -2 D=    9. x1=   2. x2=  -1.
C            a,b,c= 2.3 -2.99 -16.422 x1=   3.4 x2=  -2.1
C     But:   6.8(x-4.3)**2 = 6.8 x**2 -58.48*x+125.732
C            a,b,c= 6.8 -58.48 125.73199 
C            D= 0.000204147349  x1=   4.30105066 x2=   4.29894924
C            a,b,c= 6.8 -58.48 125.732, D=   -0.000210891725 < 0!!


      program trionymo
      implicit none
      real a,b,c,D
      real x1,x2
      real Discriminant

      print*,'Enter a,b,c:'
      read(5,*)a,b,c

C     Test if we have a well defined polynomial of 2nd degree:
      if( a .eq. 0.0) stop 'trionymo: a=0'

C     Compute the discriminant (= diakrinousa)
      D = Discriminant(a,b,c)
      print *, 'Discriminant: D=  ',D


C     Compute the roots in each case: D>0, D=0, D<0 (no roots)
      if(D .gt. 0.0 )then
       call roots(a,b,c,x1,x2)
       print *,'Roots:        x1= ',x1,' x2= ',x2
      else if (D .eq. 0.0) then
       call roots(a,b,c,x1,x2)
       print *,'Double Root:  x1= ',x1
      else
       print *,'No real roots'
      endif

      end


C     This is the function that computes the discriminant (diakrinousa)
C     A function returns a value. This value is assigned with the
C     statement:
C     Discriminant = <value>  
C     i.e. we simply assign anywhere in the program a variable with the
C     name  of the function.

      real function Discriminant(a,b,c)
      implicit none
      real a,b,c

      Discriminant = b**2 - 4.0 * a * c

      end

C     The subroutine that computes the roots.

      subroutine roots(a,b,c,x1,x2)
      implicit none
      real a,b,c
      real x1,x2
      real D, Discriminant

      if(a .eq. 0.0) stop 'roots: a=0'

      D = Discriminant(a,b,c)
      if(D.ge.0.0)then
       D = sqrt(D)
      else
       print *,'roots: Sorry, cannot compute roots, D<0=',D
       stop
      endif

      x1 = (-b + D)/(2.0*a)
      x2 = (-b - D)/(2.0*a)

      end

